function getTextWidth(text, font) {
    // re-use canvas object for better performance
    var canvas = getTextWidth.canvas || (getTextWidth.canvas = document.createElement("canvas"));
    var context = canvas.getContext("2d");
    context.font = font;
    console.log(context);
    var metrics = context.measureText(text);
    return metrics.width;
}

document.addEventListener("DOMContentLoaded", function(event) { 
	var list = document.getElementsByClassName("text");
	for (var i = 0; i < list.length; i++) {
		var font = window.getComputedStyle(list[i], null).getPropertyValue('font');
		var text = list[i].innerText;
		list[i].style.width = getTextWidth(text, font) / 2 + 35 + "px";
  }
});